#################################
#Description: Cette fonction permet de creer le tableau d'analyse des moyennes dans une fenêtre graphique
#Parametres: Elle accepte en parametre d'entree le contenu du tableau
#En sortie, elle renvoit le tableau d'analyse de la moyenne simplifie avec des symboles
# Suivi version :
#  V   | Date     | Auteur           | Description des modifications
# -----|----------|------------------|------------------------------------------
#  1.0 | 20120424 | POPIC            | Creation de la premiere version
#################################
display.table<-function(Tab){
	x11()
	#Definition des couleurs de classes
	colors<-brewer.pal(max(nrow(Tab)),"Dark2")[1:max(nrow(Tab))] 
	#Definition des couleurs des symboles
	the.cols<-brewer.pal(nrow(Tab),"RdBu")[nrow(Tab):1]
	par(mar=rep(0.1,4),bg="lightgrey",mfrow=c(ncol(Tab)+1,nrow(Tab)+1))
	plot.new()
	#Creation de l'intitule des colonnes
	for (ind.c in 1:nrow(Tab)) {
		label<-paste("*Class",rownames(Tab)[ind.c],"*")
		effectif<-paste(" ( effectif=",Tab[,(ncol(Tab))][ind.c],")")
		label<-paste(label,effectif)
		plot(0,0,axes=F,type="n",xlab="",ylab="",main="")
		text(0,0,label,cex=1.5,lwd=3,col=colors[ind.c])
		box("figure")
	}
	#Remplissage des lignes
	for (ind.v in 1:ncol(Tab)) {
		plot(0,0,axes=F,type="n",xlab="",ylab="",main="")
		text(0,0,colnames(Tab)[ind.v],cex=1.5,lwd=2)
		box("figure")
		classes.v<-cut(Tab[,ind.v],nrow(Tab),labels=F,include.lowest=TRUE)
		for (ind.c in 1:nrow(Tab)) {
			plot(0,0,axes=F,type="n",xlab="",ylab="",main="")
			points(0,0,pch=16,cex=5,col=the.cols[classes.v[ind.c]])
			box("figure")
		}
	}
}

