#################################
#Description: Cette fonction permet de réaliser la carte auto-organisatrice (self-organizing map) des données
#Parametres: save:permet de sauvegarder les graphiques en sortie
#grid.length permet de définir les dimensions dela grille (par défaut 5x5)
#grid.type permet de définir la forme de la grille. Le type 1 correspond à rectangulaire, le type 2 correspond a hexagonal
#delim permet de changer le separateur de colonnes
# Suivi version :
#  V   | Date     | Auteur           | Description des modifications
# -----|----------|------------------|------------------------------------------
#  1.0 | 20120516 | POPIC            | Creation de la premiere version
#################################
SOM<-function(grid.length=5,grid.type=1,delVar=0,delim="\t",save=FALSE){
	
	#Recuperation du fichier contenant les donnees avec selection via arborescence
	path<-selectFile()
	data<-read.delim(path,header=TRUE,sep=delim)

	#Suppression des colonnes "run" (inutile), "X" (que des valeurs manquantes), "num_exp"
	data<-delete(data)
	#Traitement d'eventuelles donnees manquantes
	data<-na.omit(data)
	
	if(delVar!=0){
		#Creation de la nouvelle matrice de donnees
		#Traitement des variables a supprimer
		delVar1<-paste(",",delVar,",",sep="")
		#On obtient les variables sous cette forme : ",Var1,Var2,...,VarN,"
		virgule<-gregexpr("[,]",delVar1,perl=F)
		nbvirgule<-length(virgule[[1]])
		nbVar<-nbvirgule-1
		Var<-0

		#Extraction des noms des variables
		for(i in 1:nbVar){
			Var[i]<-substr(delVar,(virgule[[1]][i]),(virgule[[1]][i+1])-2)
		}
	
		#Suppression des variables que l'on souhaite exclure de l'etude
		for(i in 1:nbVar){
			if(isTRUE(grep(Var[i],names(data),ignore.case=TRUE)!=0)){
				col<-grep(Var[i],names(data),ignore.case=TRUE)
				data<-data[,-col]
			}
			else{
			stop ("Le nom de Variable ",Var[i]," n'existe pas")
			}	
		}
	}

	#Centrage et reduction de la matrice de donnees
	Sdata<-scale(data)
	
	#Construction de la grille
	#Definition du type de grille
	if(grid.type==1){
		grid.type="rectangular"
	}
	else if(grid.type==2){
		grid.type="hex"
	}
	else{
		stop("Le type de grille ", grid.type, " n'existe pas\n 1: Grille rectangulaire\n 2: Grille hexagonale ")
	}
	#Définition de la grille
	grid<-somgrid(xdim=grid.length,ydim=grid.length,topo=grid.type)
	#Avec nradii, le nombre de configurations testees et criterion, le critere permettant de dire quel SOM est le meilleur
	somT<-som.tune(Sdata,grid,som.tunecontrol(grid,radii=c(1,grid$diam),nradii=40,criterion=error.kaskilagus))
	som<-somT$best.som
	
	#Construction de la carte representant les effectifs pour chaque neurone (hitmap)
	x11()
	layout(matrix(c(1,2,2,2,2,2,2,2,2,2,2),ncol=1))
	par(mai=rep(0.1,4))
	plot(0,0,type="n",axes=F,xlab="",ylab="")
	text(0,0,"Hitmap (effectif des classes)",cex=1.7)
	hitMap(som,col="darkred")
	#Sauvegarde
	if(save==TRUE){
		graphSave(name="-SOMcarteEff.png",vPath=path)
	}
	
	#Construction de la carte des distances
	pdist<-prototype.distances(som)
	pgrid<-distance.grid(pdist)
	x11()
	filled.contour(pgrid,main="Carte des distances")
	#Sauvegarde
	if(save==TRUE){
		graphSave(name="-SOMcarteDist.png",vPath=path)
	}
	
	#Reconstruction de la grille en explicitant les individus composant chaque classe
	x11()
	layout(matrix(c(rep(1,grid.length),2:((grid.length^2)+1)),byrow=T,ncol=grid.length))
	par(mai=rep(0.1,4))
	plot(0,0,type="n",axes=F,xlab="",ylab="")
	text(0,0,"Carte des individus",cex=1.7)
	#Pour chacune des classes du SOM
	for (ind in 1:(grid.length^2)){
		#Si la case n'est pas vide
		if (sum(som$classif==ind)>0){
			#On récupère le numéro des individus
			som.ind<-which(som$classif==ind)
			par(mai=rep(0.1,4))
			plot(1:length(som$classif),1:length(som$classif),type="n",main="",xlab="",ylab="",axes=F)
			text(som.ind,som.ind,som.ind-1,lwd=2,col="darkred")
			box("figure",col="black")
		}
		#Si la case est vide
		else{
			plot(0,0,type="n",axes=F,main="",xlab="",ylab="")
			box("figure",col="black")
		}
	}
	if(save==TRUE){
		graphSave(name="-SOMcarteInd.png",vPath=path)
	}
	
	#Construction d'une matrice de graphique contenant la valeur moyennes des variables pour chacune des classes
	nbVar<-length(names(data))
	#Creation d'un tableau contenant les moyennes
	#on aura tab.mean[individu,variable]
	tab.mean<-array(dim=c(grid.length^2,nbVar))
	#Creation d'un tableau contenant les ecart-types
	#on aura tab.sd[individu,variable]
	tab.sd<-array(dim=c(grid.length^2,nbVar))
	
	### Etude de la moyenne ###
	#Pour chacune des variables choisies
	for(k in 1:nbVar){
		#Pour chacune des classes du SOM
		for(ind in 1:(grid.length^2)){
			if(sum(som$classif==ind)>0){
				#On recupere le numero des individus
				som.ind<-which(som$classif==ind)
				vect.value<-0
				#Pour chacune des valeurs de la classe
				for(j in 1:length(som.ind)){
					#On calcule la moyenne des individus pour la variable souhaitee
					vect.value<-vect.value+som$data[som.ind[j],k]
					mean.value<-vect.value/(length(som.ind))
					mean.value<-round(mean.value,2)						
				}
				#On incremente le tableau contenant les moyennes
				tab.mean[ind,k]<-mean.value
			}
		}
	}
	#Construction de la grille
	coloring<-brewer.pal(9,"RdYlBu")[9:1]
	nbLig<-ceiling(sqrt(ncol(data)))
	#Si l'on a plus de 4*4 graphiques par device
	if(nbLig>4){
		nbdevice<-ceiling(ncol(data)/16)
		l<-16
		k<-1
		for(i in 1:nbdevice){
			x11()
			par(mai=rep(0.1,4))
			layout(matrix(c(rep(1,4),2:(4^2+1)),ncol=4,byrow=T))
			plot(0,0,type="l",axes=F,xlab="",ylab="")
			text(0,0,"Etude des moyennes",cex=1.7)
			for(k in k:l){
				bornes<-cut(tab.mean[,k],breaks=seq(range(tab.mean[,k],na.rm=TRUE)[1],range(tab.mean[,k],na.rm=TRUE)[2],length=8),include.lowest=TRUE)
				plot(grid,col=coloring[bornes],main=names(data[k]))
			}
			k<-l+1
			l<-l+16
			if(i==nbdevice-1){
				l<-ncol(data)
			}
			#Sauvegarde
			if(save==TRUE){
				dot<-gregexpr("[.]",path,perl=F)
				pathF<-substr(path,1,max(dot[[1]])-1)
				path1<-paste(pathF,"-SOMcarteNivMoy",sep="")
				path2<-paste(path1,i,sep="")
				newPath<-paste(path2,".png",sep="")
				dev.print(png, file=newPath, width=800, height=600)
			}	
		}		
	}
	else{
		x11()
		par(mai=rep(0.1,4))
		layout(matrix(c(rep(1,nbLig),2:(nbLig^2+1)),ncol=nbLig,byrow=T))
		plot(0,0,type="l",axes=F,xlab="",ylab="")
		text(0,0,"Etude des moyennes",cex=1.7)
		for(k in 1:nbVar){
			bornes<-cut(tab.mean[,k],breaks=seq(range(tab.mean[,k],na.rm=TRUE)[1],range(tab.mean[,k],na.rm=TRUE)[2],length=8),include.lowest=TRUE)
			plot(grid,col=coloring[bornes],main=names(data[k]))
		}
		#Sauvegarde
		if(save==TRUE){
			graphSave(name="-SOMcarteNivMoy.png",vPath=path)
		}
	}
	### Etude de l'ecart-type ###
	#Pour chacune des variables choisies
	for(k in 1:nbVar){
		#Pour chacune des classes du SOM
		for(ind in 1:(grid.length^2)){
			if(sum(som$classif==ind)>0){
				#On recupere le numero des individus
				som.ind<-which(som$classif==ind)
				vect.value<-0
				#Pour chacune des valeurs de la classe
				for(j in 1:length(som.ind)){
					#On recupere les valeurs de chacun des individus
					vect.value[j]<-som$data[som.ind[j],k]			
				}
				#on calcule l'ecart-type des variales constituant la classe
				sd.value<-sd(vect.value)
				tab.sd[ind,k]<-round(sd.value,2)			
			}
		}
	}
	#Construction de la grille
	coloring<-brewer.pal(9,"RdYlBu")[9:1]
	nbLig<-ceiling(sqrt(ncol(data)))
	#Si l'on a plus de 4*4 graphiques par device
	if(nbLig>4){
		nbdevice<-ceiling(ncol(data)/16)
		l<-16
		k<-1
		for(i in 1:nbdevice){
			x11()
			par(mai=rep(0.1,4))
			layout(matrix(c(rep(1,4),2:(4^2+1)),ncol=4,byrow=T))
			plot(0,0,type="l",axes=F,xlab="",ylab="")
			text(0,0,"Etude des écarts types",cex=1.7)
			for(k in k:l){
				bornes<-cut(tab.sd[,k],breaks=seq(range(tab.sd[,k],na.rm=TRUE)[1],range(tab.sd[,k],na.rm=TRUE)[2],length=8),include.lowest=TRUE)
				plot(grid,col=coloring[bornes],main=names(data[k]))
			}
			k<-l+1
			l<-l+16
			if(i==nbdevice-1){
				l<-ncol(data)
			}
			#Sauvegarde
			if(save==TRUE){
				dot<-gregexpr("[.]",path,perl=F)
				pathF<-substr(path,1,max(dot[[1]])-1)
				path1<-paste(pathF,"-SOMcarteNivSD",sep="")
				path2<-paste(path1,i,sep="")
				newPath<-paste(path2,".png",sep="")
				dev.print(png, file=newPath, width=800, height=600)
			}	
		}		
	}
	else{
		x11()
		par(mai=rep(0.1,4))
		layout(matrix(c(rep(1,nbLig),2:(nbLig^2+1)),ncol=nbLig,byrow=T))
		plot(0,0,type="l",axes=F,xlab="",ylab="")
		text(0,0,"Etude des écarts types",cex=1.7)
		for(k in 1:nbVar){
			bornes<-cut(tab.sd[,k],breaks=seq(range(tab.sd[,k],na.rm=TRUE)[1],range(tab.sd[,k],na.rm=TRUE)[2],length=8),include.lowest=TRUE)
			plot(grid,col=coloring[bornes],main=names(data[k]))
		}
		#Sauvegarde
		if(save==TRUE){
			graphSave(name="-SOMcarteNivSD.png",vPath=path)
		}
	}
	som
}