#################################
#Description: Cette fonction permet de tracer un graphique representant la distance (euclidienne) entre les individus
#Parametres:Elle possede 3 parametres d'entree
#delVar qui permet de specifier les variables que l'on veut exclure du nuage de points
#delCol qui correspond aux variables que l'on va utiliser pour les couleurs. Par defaut, delCol est egale a delVar
#bagPlot permet de tracer le bagplot des donnees
#delim permet de changer le separateur de colonnes
#save permet de dire si l'on veut sauvegarder ou non; par defaut, il est a FALSE
# Suivi version :
#  V   | Date     | Auteur           | Description des modifications
# -----|----------|------------------|------------------------------------------
#  1.0 | 20120413 | POPIC            | Creation de la premiere version
#################################
MDS<-function(delVar=0,delCol=0,bagPlot=FALSE,delim="\t",save=FALSE){

	#Recuperation du fichier contenant les donnees avec selection via arborescence
	path<-selectFile()
	data<-read.delim(path,header=TRUE,sep=delim)

	#Suppression des colonnes "run" (inutile), "X" (que des valeurs manquantes), "num_exp"
	dataProj<-delete(data)
	#Traitement d'eventuelles donnees manquantes
	dataProj<-na.omit(dataProj)

	if(delVar!=0){
		#Traitement des variables a supprimer
		vProj1<-paste(",",delVar,",",sep="")
		#On obtient les variables sous cette forme : ",Var1,Var2,...,VarN,"
		virgule<-gregexpr("[,]",vProj1,perl=F)
		nbvirgule<-length(virgule[[1]])
		nbVar<-nbvirgule-1
		Var<-0

		#Extraction des noms des variables
		for(i in 1:nbVar){
			Var[i]<-substr(delVar,(virgule[[1]][i]),(virgule[[1]][i+1])-2)
		}
	
		#Suppression des variables que l'on souhaite exclure de l'etude
		for(i in 1:nbVar){
			if(isTRUE(grep(Var[i], names(dataProj), ignore.case=TRUE)!=0)){
				col<-grep(Var[i], names(dataProj), ignore.case=TRUE)
				dataProj<-dataProj[,-col]
			}
			else{
				stop("Le nom de Variable ",Var[i]," n'existe pas")
			}	
		}
	}

	#Creation de la matrice de couleur
	dataCoul<-dataProj

	if(delCol!=0){
		#Traitement des variables a supprimer de la coloration
		vCoul1<-paste(",",delCol,",",sep="")
		#On obtient les Variables sous cette forme : ",Var1,Var2,...,VarN,"
		virgule<-gregexpr("[,]",vCoul1,perl=F)
		nbvirgule<-length(virgule[[1]])
		nbVar<-nbvirgule-1
		Var<-0

		#Extraction des noms des variables
		for(i in 1:nbVar){
			Var[i]<-substr(delCol,(virgule[[1]][i]),(virgule[[1]][i+1])-2)
		}	
	
		#Suppression des variables que l'on ne souhaite pas mettre en couleur
		for(i in 1:nbVar){
			if(isTRUE(grep(Var[i], names(dataCoul), ignore.case=TRUE)!=0)){
				col<-grep(Var[i], names(dataCoul), ignore.case=TRUE)
				dataCoul<-dataCoul[,-col]
			}
			else{
				stop("Le nom de Variable ",Var[i]," n'existe pas ou la variable a déjà été supprimée\n")
			}	
		}
	}	

	#Centrage et reduction de la matrice de projection
	dataCR<-scale(dataProj)
	#Creation d'une matrice de distance
	mat.dataCR<-dist(dataCR, method = "euclidean")
	#Creation des axes du nuage de points:
	X<-cmdscale(mat.dataCR)[,1]
	Y<-cmdscale(mat.dataCR)[,2]

	#Choix des options pour la colorisation
	nbvCoul<-length(dataCoul)
	coloring<-brewer.pal(9,"Oranges")[1:9]

	#Trace des graphiques
	#Traitement de l'affichage graphique
	nbLig<-ceiling(sqrt(nbvCoul))

	#Si l'on doit afficher plus de 16 MDS
	if (nbLig>4){
		nbdevice<-ceiling(nbvCoul/16)
		k<-1
		l<-16
		#Trace des MDS
		for (i in 1:nbdevice){
			x11()
			par(mfrow=c(4,4))
			for (j in k:l){
				bornes<-cut(dataCoul[,j],breaks=seq(range(dataCoul[,j],na.rm=TRUE)[1],range(dataCoul[,j],na.rm=TRUE)[2],length=8),include.lowest=TRUE) 
				plot(X,Y,col=coloring[bornes],type="p",pch=16,main="Matrice de distance",sub=names(dataCoul[j]))
			}
			k<-l+1
			l<-l+16
			if(i==nbdevice-1){
				l<-ncol(dataCoul)
			}
			#Si l'utilisateur veut sauvegarder les graphiques
			if(save==TRUE){
				dot<-gregexpr("[.]",path,perl=F)
				pathF<-substr(path,1,max(dot[[1]])-1)
				path1<-paste(pathF,"-MDSGraph",sep="")
				path2<-paste(path1,i,sep="")
				newPath<-paste(path2,".png",sep="")
				dev.print(png, file=newPath, width=1000, height=800)
			}
		}
	}

	#Si l'on doit afficher 16 MDS ou moins
	if (nbLig<=4){
		par(mfrow=c(nbLig,nbLig))
		#Trace des MDS
		for (i in 1:nbvCoul){
			bornes<-cut(dataCoul[,i],breaks=seq(range(dataCoul[,i],na.rm=TRUE)[1],range(dataCoul[,i],na.rm=TRUE)[2],length=8),include.lowest=TRUE) 
			plot(X,Y,col=coloring[bornes],type="p",pch=16,main="Matrice de distance",sub=names(dataCoul[i]))
		}
		#Si l'utilisateur veut sauvegarder le graphique
		if(save==TRUE){
			graphSave(name="-MDSgraph.png",vPath=path)
		}
	}
	#Trace du bagplot, a la demande
	if(bagPlot==TRUE){
		x11()
		bagplot(X,Y,factor=2,dkmethod=1,main="Bagplot des observations",axes=F,pch=8,show.looppoints=TRUE, show.outlier=TRUE,show.bagpoints=TRUE, show.whiskers=TRUE,show.loophull=TRUE,show.baghull=TRUE, verbose=FALSE)
		box()
		text(X,Y,as.character(data[,1]),cex=1)
		if(save==TRUE){
			graphSave(name="-MDSbagplot.png",vPath=path)
		}
	}
	list("x"=X,"y"=Y)
}



