#################################
#Description: Cette fonction permet de generer automatiquement un graphique des correlations
#Parametres: save permet de sauvegarder le graphique 
#delVar permet de supprimer des variables de l'etude
#delim permet de changer le separateur de colonnes
# Suivi version :
#  V   | Date     | Auteur           | Description des modifications
# -----|----------|------------------|------------------------------------------
#  1.0 | 20120405 | POPIC            | Creation de la premiere version
#################################
CORR<-function(delVar=0,delim="\t",save=FALSE){
	#Recuperation du fichier contenant les donnees avec selection via arborescence
	path<-selectFile()
	data<-read.delim(path,header=TRUE,sep=delim)

	#Suppression des colonnes "run" (inutile), "X" (que des valeurs manquantes), "num_exp", "nb_step"
	data<-delete(data)
	#Traitement d'eventuelles donnees manquantes
	data<-na.omit(data)

	#Suppression des variables indesirables
	if(delVar!=0){
		#Traitement des variables a supprimer
		delVar1<-paste(",",delVar,",",sep="")
		#On obtient les variables sous cette forme : ",Var1,Var2,...,VarN,"
		virgule<-gregexpr("[,]",delVar1,perl=F)
		nbvirgule<-length(virgule[[1]])
		nbVar<-nbvirgule-1
		Var<-0

		#Extraction des noms des variables
		for(i in 1:nbVar){
			Var[i]<-substr(delVar,(virgule[[1]][i]),(virgule[[1]][i+1])-2)
		}
	
		#Suppression des variables que l'on souhaite exclure de l'etude
		for(i in 1:nbVar){
			if(isTRUE(grep(Var[i], names(data), ignore.case=TRUE)!=0)){
				col<-grep(Var[i], names(data), ignore.case=TRUE)
				data<-data[,-col]
			}
			else{
				stop ("Le nom de variable ",Var[i]," n'existe pas")
			}	
		}
	}

	#Creation de la matrice de correlation
	correlation<-cor(data,use="complete.obs")

	#Creation d'intervalles et gestion des couleurs
	colors<-brewer.pal(11,"RdBu")[11:1]   
	bornes<-cut(correlation,breaks=seq(-1,1,length=10),include.lowest=TRUE)

	#Creation du graphique
	#Variation de la taille de la police selon le nombre de variables
	if (length(data)>20){
		plotcorr(correlation, col=colors[bornes], main="Graphique des corrélations entre les variables",cex.lab=0.6,asp=1,mar=0.1+c(1,1,3,1))	
	}
	else{
		plotcorr(correlation, col=colors[bornes], main="Graphique des corrélations entre les variables",cex.lab=1,asp=1,mar=0.1+c(1,1,3,1))
	}

	#Si l'utilisateur veut sauvegarder le graphique
	if(save==TRUE){
		graphSave(name="-CORRgraph.png",vPath=path)
	}
	correlation
}

