#################################
#Description: Cette fonction permet de realiser une classification ascendante hierarchique 
#Parametres: class, choix du nombre de classes dessinees sur le dendrogramme
#manSelect, pour selectionner a la main, sur le dendrogramme, un nombre de classes (selection manuelle)
#save permet de sauvegarder le graphique (dendrogramme+MDS)
#delVar permet de supprimer des variables de l'etude
#MAV permet d'importer le tableau d'analyse des moyennes en fichier csv
#bPlot  permet d'obtenir les boites a moustaches de chaque classe pour chaque variable
#delim permet de changer le separateur de colonne
# Suivi version :
#  V   | Date     | Auteur           | Description des modifications
# -----|----------|------------------|------------------------------------------
#  1.0 | 20120531 | POPIC            | Creation de la premiere version
#################################

CAH<-function(class=0,delVar=0,manSelect=FALSE,MAV=FALSE,bPlot=FALSE,delim="\t",save=FALSE){

	#Gestion de conflit
	if ((class>=1)&&(manSelect==TRUE)){
		stop("Impossible de spécifier un nombre de classe de manière automatique et manuelle à la fois")
	}
	if((class==0)&&(manSelect==FALSE)){
		stop("Veuillez spécifier un nombre de classe ou effectuer une sélection manuelle")
	}
	
	#Recuperation du fichier contenant les donnees avec selection via arborescence
	path<-selectFile()
	data<-read.delim(path,header=TRUE,sep=delim)

	#Suppression des colonnes "run" (inutile), "X" (que des valeurs manquantes), "num_exp"
	data<-delete(data)
	#Traitement d'eventuelles donnees manquantes
	data<-na.omit(data)

	#Suppression des variables indesirables
	if(delVar!=0){
		#Traitement des variables a supprimer
		delVar1<-paste(",",delVar,",",sep="")
		#On obtient les variables sous cette forme : ",Var1,Var2,...,VarN,"
		virgule<-gregexpr("[,]",delVar1,perl=F)
		nbvirgule<-length(virgule[[1]])
		nbVar<-nbvirgule-1
		Var<-0

		#Extraction des noms des variables
		for(i in 1:nbVar){
			Var[i]<-substr(delVar,(virgule[[1]][i]),(virgule[[1]][i+1])-2)
		}
	
		#Suppression des variables que l'on souhaite exclure de l'etude
		for(i in 1:nbVar){
			if(isTRUE(grep(Var[i], names(data), ignore.case=TRUE)!=0)){
				col<-grep(Var[i], names(data), ignore.case=TRUE)
				data<-data[,-col]
			}
			else{
				stop ("Le nom de Variable ",Var[i]," n'existe pas")
			}	
		}
	}

	#Centrage et reduction des donnees
	dataCR<-scale(data)
	#Creation d'une matrice de distance:
	mat.dataCR<-dist(dataCR, method="euclidean")
	#Creation des axes du nuage de points:
	X<-cmdscale(mat.dataCR)[,1]
	Y<-cmdscale(mat.dataCR)[,2]

	#Mise en oeuvre de la methode de classification ascendante hierarchique
	data.cah<-hclust(mat.dataCR, method="ward")

	#Trace du dendrogramme avec class, le nombre de classes choisies
	#Si l'utilisateur a choisit plusieurs valeurs de classes
	if (length(class)>1){
		if((MAV==TRUE)||(bPlot==TRUE)){
			stop("Impossible d'enregistrer les données relatives à l'analyse des moyennes ou d'afficher les boîtes à moustaches en sélection de classes mutliple")
		}
		vClass<-0
		nbLig<-ceiling(sqrt(length(class)*2))	
		par(mfrow=c(nbLig,nbLig))
		for (i in 1:length(class)){
			#Creation du dendrogramme
			plot(data.cah, cex=0.5, main="Dendrogramme de classes", sub=paste(class[i],"Classes"), ylim=c(0,100), ylab="Inertie intra-groupe",font.sub=2,hang=-1)
			#Ajout de la legende et definition des couleurs
			colors<-brewer.pal(max(class),"Dark2")[1:max(class)]
			legend(1,80,paste("Class",1:class[i]),pch=8,col=colors,text.col=colors,bty="n",cex=0.5)
			#Trace des groupes sur le dendrogramme
			res<-rect.hclust (data.cah, class[i], border=colors)
			#Creation du MDS 
			vClass<-cutree(data.cah,class[i])
			#Colorisation des classes
			plot(X,Y,type="n",main="Matrice de distance")
			#k=nombre de classes
			for(k in 1:(length(res))){
				#i=nombre d'individus dans la classe
				for(j in 1:(length(res[[k]]))){
					points(X[res[[k]][j]],Y[res[[k]][j]],type="p",sub=paste(class[i],"Classes"),font.sub=2,pch=16,col=colors[k])
				}
			}
			#Si l'utilisateur veut sauvegarder le graphique
			if(save==TRUE){
				graphSave(name="-CAHgraphMulti.png",vPath=path)
			}	
			#Creation du tableau d'analyse des moyennes
			#Creation d'un vecteur contenant le numero de classe de chaque individu
			vect<-0
			#Creation d'un vecteur content le nombre d'individu dans chaque classe
			eff<-0
			#k=nombre de classes
			for(k in 1:(length(res))){
				eff[k]<-length(res[[k]])
				#j=nombre d'individus dans la classe
				for(j in 1:(length(res[[k]]))){
					#i=nombre d'individus au total
					for(i in 1:length(vClass)){
						if(res[[k]][j]==i){
						vect[i]<-k
						}
					}
				}
			}
			#On ajoute une colonne contenant les numeros de classe au jeu de donnees
			step1<-merge(data,vect,by="row.names",sort=FALSE)
			tabMoy<-aggregate(step1[,-1], list(step1$y), mean, na.rm=TRUE)
			tabMoy<-round(tabMoy,2)
			#Suppression de la colonne "y", utilisee pour la creation du tableau
			tabMoy<-tabMoy[,-(ncol(tabMoy))]
			#Ajout d'une colonne contenant les effectifs
			tabMoy[,(ncol(tabMoy))+1]<-eff
			names(tabMoy)[ncol(tabMoy)]<-"Effectifs"
		}
	}
	#Si l'utilisateur n'a choisit qu'une valeur pour definir la classe
	else{
		if(!manSelect){
			par(mfrow=c(1,2))
			vClass<-0
			#Creation du dendrogramme
			plot(data.cah, cex=0.5, main="Dendrogramme de classes", ylim=c(0,100), ylab="Inertie intra-groupe",hang=-1)
			#Ajout de la legende et definition des couleurs
			colors<-brewer.pal(class,"Dark2")[1:class]  
			legend(1,80,paste("Class",1:class),pch=8,col=colors,text.col=colors,bty="n",cex=0.8)
			#Trace des groupes sur le dendrogramme
			res<-rect.hclust(data.cah, class, border=colors)
			#Creation du MDS 
			vClass<-cutree(data.cah,class)
			plot(X,Y,type="n",main="Matrice de distance")
			#Colorisation des classes
			#k=nombre de classes
			for(k in 1:(length(res))){
				#i=nombre d'individus dans la classe
				for(i in 1:(length(res[[k]]))){
					text(X[res[[k]][i]],Y[res[[k]][i]],res[[k]][i]-1,cex=0.8,col=colors[k])
				}
			}
			#Si l'utilisateur veut sauvegarder le graphique
			if(save==TRUE){
				dot<-gregexpr("[.]",path,perl=F)
				pathF<-substr(path,1,max(dot[[1]])-1)
				name<-paste("-CAHgraph",class,"Cl.png",sep="")
				newPath<-paste(pathF,name,sep="")
				dev.print(png,file=newPath,width=800,height=600)
			}
			#Creation du tableau d'analyse des moyennes
			#Creation d'un vecteur contenant le numero de classe de chaque individu
			vect<-0
			#Creation d'un vecteur contenant le nombre d'individu dans chaque classe
			eff<-0
			#k=nombre de classes
			for(k in 1:(length(res))){
				eff[k]<-length(res[[k]])
				#j=nombre d'individus dans la classe
				for(j in 1:eff[k]){
					#i=nombre d'individus au total
					for(i in 1:length(vClass)){
						if(res[[k]][j]==i){
							vect[i]<-k
						}
					}
				}
			}	
			step1<-merge(data,vect,by="row.names",sort=FALSE)
			tabMoy<-aggregate(step1[,-1], list(step1$y), mean, na.rm=TRUE)
			tabMoy<-round(tabMoy,2)
			#Suppression de la colonne "y", utilisee pour la creation du tableau
			tabMoy<-tabMoy[,-(ncol(tabMoy))]
			#Ajout d'une colonne contenant les effectifs
			tabMoy[,(ncol(tabMoy))+1]<-eff
			names(tabMoy)[ncol(tabMoy)]<-"Effectifs"
			#Suppression de la colonne "group.1" pour l'analyse de la moyenne avec les symboles
			tabMoy<-tabMoy[,-1]
			display.table(tabMoy)
			#Si l'utilisateur veut sauvegarder le tableau d'analyse des moyennes en csv
			if(MAV==TRUE){
				dot<-gregexpr("[.]",path,perl=F)
				pathF<-substr(path,1,max(dot[[1]])-1)
				tabMoy.table<-xtable(tabMoy)
				#Importation de ce tableau en fichier csv
				name<-paste("-CAHanalyseMoy",class,"Cl.csv",sep="")
				newPath<-paste(pathF,name,sep="")
				write.csv2(tabMoy,file=newPath)
			}	
			#Si l'utilisateur veut sauvegarder le tableau d'analyse des moyennes avec les symboles, en .png
			if(save==TRUE){
				dot<-gregexpr("[.]",path,perl=F)
				pathF<-substr(path,1,max(dot[[1]])-1)
				tabMoy.table<-xtable(tabMoy)
				#Importation de ce tableau en fichier png
				name<-paste("-CAHanalyseMoy",class,"Cl.png",sep="")
				newPath<-paste(pathF,name,sep="")
				dev.print(png,file=newPath,width=800,height=600)
			}
			#Creation de la matrice de boites a moustaches
			if(bPlot==TRUE){
				nbLig<-ceiling(sqrt(length(data)*2))
				#Si l'on a plus de 9 boites a moustaches (affichage 3x3)
				if(nbLig>3){
					nbdevice<-ceiling(ncol(data)/9)
					l<-9
					l2<-1
					if (nbdevice==1) {l <- ncol(data)}
					for(i in 1:nbdevice){
						x11()
						par(mfrow=c(3,3))
						for(k in l2:l){
							#Definition de la longueur de l'axe des ordonnees
							limInf<-0
							limSup<-0
							#Une satisfaction est comprise entre -100 et 100
							if(isTRUE(grep("satisfaction", names(data[k]), ignore.case=TRUE)!=0)){
								col<-grep("satisfaction", names(data[k]), ignore.case=TRUE)
								limInf<--100
								limSup<-100
							}
							#Une relation est comprise entre -10 et 10
							if(isTRUE(grep("state", names(data[k]), ignore.case=TRUE)!=0)){
								col<-grep("state", names(data[k]), ignore.case=TRUE)
								limInf<--10
								limSup<-10
							}
							#Si c'est autre chose, on prend le maximum et le minimum
							else{
								limInf<-min(data[,k],na.rm=TRUE)
								limSup<-max(data[,k],na.rm=TRUE)
							}
							boxplot(data[,k]~step1[,(length(step1))],sub=names(data[k]),ylim=c(limInf,limSup),varwidth=TRUE,border=c(colors))
						}
						l2<-l+1
						l<-l+9
						if(i==nbdevice-1){
							l<-ncol(data)
						}
						#Sauvegarde
						if(save==TRUE){
							dot<-gregexpr("[.]",path,perl=F)
							pathF<-substr(path,1,max(dot[[1]])-1)
							path1<-paste(pathF,"-CAHboxPlot",sep="")
							path2<-paste(path1,i,sep="")
							newPath<-paste(path2,".png",sep="")
							dev.print(png, file=newPath, width=800, height=600)
						}	
					}
				}
				else{
					x11()
					par(mfrow=c(nbLig,nbLig))
					for(i in 1:ncol(data)){
						#Definition de la longueur de l'axe des ordonnees
						limInf<-0
						limSup<-0
						#Une satisfaction est comprise entre -100 et 100
						if(isTRUE(grep("satisfaction", names(data[i]), ignore.case=TRUE)!=0)){
							col<-grep("satisfaction", names(data[i]), ignore.case=TRUE)
							limInf<--100
							limSup<-100
						}
						#Une relation est comprise entre -10 et 10
						if(isTRUE(grep("state", names(data[i]), ignore.case=TRUE)!=0)){
							col<-grep("state", names(data[i]), ignore.case=TRUE)
							limInf<--10
							limSup<-10
						}
						#Si c'est autre chose, on prend le maximum et le minimum
						else{
							limInf<-min(data[,i],na.rm=TRUE)
							limSup<-max(data[,i],na.rm=TRUE)
						}
						boxplot(data[,i]~step1[,(length(step1))],sub=names(data[i]),ylim=c(limInf,limSup),varwidth=TRUE,border=c(colors))
					}
					#Sauvegarde
					if(save==TRUE){
						graphSave(name="-CAHboxPlot.png",vPath=path)
					}
				}
			}	
		}	
	}
	
	#Selection manuelle des classes:
	if(manSelect){
		par(mfrow=c(1,2))
		plot(data.cah, cex=0.5, main="Dendrogramme de classes", ylim=c(0,100), ylab="Inertie intra-groupe", hang=-1) 
		data.cah.id<-identify(data.cah)
		#data.cah.id contient les differents individus dans chaque classe
		#Ajout de la legende et definition des couleurs
		colors<-brewer.pal(length(data.cah.id),"Dark2")[1:length(data.cah.id)] 
		legend(1,80,paste("Class",1:length(data.cah.id)),pch=8,col=colors,text.col=colors,bty="n",cex=0.8)  
		#Trace des groupes sur le dendrogramme
		res<-rect.hclust(data.cah, length(data.cah.id), border=colors)
		#Creation du MDS
		vClass<-cutree(data.cah,length(data.cah.id))
		plot(X,Y,type="n",main="Matrice de distance")
		#Colorisation des classes
		#k=nombre de classes
		for(k in 1:(length(res))){
			#i=nombre d'individus dans la classe
			for(i in 1:(length(res[[k]]))){
				text(X[res[[k]][i]],Y[res[[k]][i]],res[[k]][i]-1,cex=0.8,col=colors[k])
			}
		}
		#Si l'utilisateur veut sauvegarder le graphique
		if(save==TRUE){
			graphSave(name="-CAHgraph.png",vPath=path)
		}
		#Creation du tableau d'analyse des moyennes
		#Creation d'un vecteur contenant le numero de classe de chaque individu
		vect<-0
		#Creation d'un vecteur content le nombre d'individu dans chaque classe
		eff<-0
		#k=nombre de classes
		for(k in 1:(length(res))){
			eff[k]<-length(res[[k]])
			#j=nombre d'individus dans la classe
			for(j in 1:(length(res[[k]]))){
				#i=nombre d'individus au total
				for(i in 1:length(vClass)){
					if(res[[k]][j]==i){
						vect[i]<-k
					}
				}
			}
		}
		step1<-merge(data,vect,by="row.names",sort=FALSE)
		tabMoy<-aggregate(step1[,-1],by=list(step1$y),mean, na.rm=TRUE)
		tabMoy<-round(tabMoy,2)
		#Suppression de la colonne "y", utilisee pour la creation du tableau
		tabMoy<-tabMoy[,-(ncol(tabMoy))]
		#Ajout d'une colonne contenant les effectifs
		tabMoy[,(ncol(tabMoy))+1]<-eff
		names(tabMoy)[ncol(tabMoy)]<-"Effectifs"
		#Suppression de la colonne "group.1" pour l'analyse de la moyenne avec les symboles
		tabMoy<-tabMoy[,-1]
		display.table(tabMoy)
		#Si l'utilisateur veut sauvegarder le tableau d'analyse des moyennes en csv
		if(MAV==TRUE){
			dot<-gregexpr("[.]",path,perl=F)
			pathF<-substr(path,1,max(dot[[1]])-1)
			#Importation de ce tableau en fichier csv
			name<-paste("-CAHanalyseMoy",length(data.cah.id),"Cl.csv",sep="")
			newPath<-paste(pathF,name,sep="")
			write.csv2(tabMoy,file=newPath)	
		}
		#Si l'utilisateur veut sauvegarder le tableau d'analyse des moyennes avec les symboles, en .png
		if(save==TRUE){
			dot<-gregexpr("[.]",path,perl=F)
			pathF<-substr(path,1,max(dot[[1]])-1)
			#Importation de ce tableau en fichier png
			name<-paste("-CAHanalyseMoy",length(data.cah.id),"Cl.png",sep="")
			newPath<-paste(pathF,name,sep="")
			dev.print(png,file=newPath,width=800,height=600)
		}
		#Creation de la matrice de boites a moustaches
		if(bPlot==TRUE){
			nbLig<-ceiling(sqrt(length(data)*2))
			if(nbLig>3){
				nbdevice<-ceiling(ncol(data)/9)
				l<-9
				l2<-1
				if (nbdevice==1) {l<-ncol(data)}
				for(i in 1:nbdevice){
					x11()
					par(mfrow=c(3,3))
					for(k in l2:l){
						#Definition de la longueur de l'axe des ordonnees
						limInf<-0
						limSup<-0
						#Une satisfaction est comprise entre -100 et 100
						if(isTRUE(grep("satisfaction", names(data[k]), ignore.case=TRUE)!=0)){
							col<-grep("satisfaction", names(data[k]), ignore.case=TRUE)
							limInf<--100
							limSup<-100
						}
						#Une relation est comprise entre -10 et 10
						if(isTRUE(grep("state", names(data[k]), ignore.case=TRUE)!=0)){
							col<-grep("state", names(data[k]), ignore.case=TRUE)
							limInf<--10
							limSup<-10
						}
						#Si c'est autre chose, on prend le maximum et le minimum
						else{
							limInf<-min(data[,k])
							limSup<-max(data[,k])
						}
						boxplot(data[,k]~step1[,(length(step1))],sub=names(data[k]),ylim=c(limInf,limSup),varwidth=TRUE,border=c(colors))
					}
					l2<-l+1
					l<-l+9
					if(i==nbdevice-1){
						l<-ncol(data)
					}
					#Sauvegarde
					if(save==TRUE){
						dot<-gregexpr("[.]",path,perl=F)
						pathF<-substr(path,1,max(dot[[1]])-1)
						path1<-paste(pathF,"-CAHboxPlot",sep="")
						path2<-paste(path1,i,sep="")
						newPath<-paste(path2,".png",sep="")
						dev.print(png, file=newPath, width=800, height=600)
					}	
				}
			} 	else {
				x11()
				par(mfrow=c(nbLig,nbLig))
				for(i in 1:ncol(data)){
					#Definition de la longueur de l'axe des ordonnees
					limInf<-0
					limSup<-0
					#Une satisfaction est comprise entre -100 et 100
					if(isTRUE(grep("satisfaction", names(data[i]), ignore.case=TRUE)!=0)){
						col<-grep("satisfaction", names(data[i]), ignore.case=TRUE)
						limInf<--100
						limSup<-100
					}
					#Une relation est comprise entre -10 et 10
					if(isTRUE(grep("state", names(data[i]), ignore.case=TRUE)!=0)){
						col<-grep("state", names(data[i]), ignore.case=TRUE)
						limInf<--10
						limSup<-10
					}
					#Si c'est autre chose, on prend le maximum et le minimum
					else{
						limInf<-min(data[,i])
						limSup<-max(data[,i])
					}
					boxplot(data[,i]~step1[,(length(step1))],sub=names(data[i]),ylim=c(limInf,limSup),varwidth=TRUE,border=c(colors))
				}	
				#Sauvegarde
				if(save==TRUE){
					graphSave(name="-CAHboxPlot.png",vPath=path)
				}
			}
		}
	}
	vClass
}

